/**
 * ANU 7 MAPPING (Standard)
 * Extracted from vignesh-seven/telugu-encoder
 */
window.anu7Mapping = {
    vowels: {
        3074: String.fromCharCode(0x2B), // ం 
        3077: String.fromCharCode(0x6E), // అ
        3078: String.fromCharCode(0x80), // ఆ
        3079: String.fromCharCode(0x82), // ఇ
        3080: String.fromCharCode(0x87), // ఈ
        3081: String.fromCharCode(0x96), // ఉ
        3082: String.fromCharCode(0x7D), // ఊ
        3086: String.fromCharCode(0x62), // ఎ
        3087: String.fromCharCode(0x40), // ఏ
        3088: String.fromCharCode(0xD7), // ఐ
        3090: String.fromCharCode(0xFF), // ఒ
        3091: String.fromCharCode(0x7A), // ఓ
        3092: String.fromCharCode(0x57), // ఔ
    },

    extensions: {
        3093: String.fromCharCode(0xD8), // క్క
        3094: String.fromCharCode(0x89), // క్ఖ
        3095: String.fromCharCode(0x5A), // క్గ
        3096: String.fromCharCode(0xE9), // క్ఘ
        3097: String.fromCharCode(0x5F), // క్ఙ
        3098: String.fromCharCode(0xCC), // క్చ
        3099: String.fromCharCode(0xCC) + String.fromCharCode(0xDB), // క్ఛ
        3100: String.fromCharCode(0xA8), // క్జ
        3101: String.fromCharCode(0x5F), // క్ఝ
        3102: String.fromCharCode(0xE3), // క్ఞ
        3103: String.fromCharCode(0xBC), // క్ట
        3104: String.fromCharCode(0xF7), // క్ఠ
        3105: String.fromCharCode(0xA6), // క్డ
        3106: String.fromCharCode(0x5F), // క్ఢ
        3107: String.fromCharCode(0x92), // క్ణ
        3108: String.fromCharCode(0xEF), // క్త
        3109: String.fromCharCode(0x9C), // క్థ
        3110: String.fromCharCode(0xDD), // క్ద
        3111: String.fromCharCode(0xC6), // క్ధ
        3112: String.fromCharCode(0x95), // క్న
        3113: "", // క్
        3114: String.fromCharCode(0xCE), // క్ప
        3115: String.fromCharCode(0xCE) + String.fromCharCode(0xDB), // క్ఫ
        3116: String.fromCharCode(0xD2), // క్బ
        3117: String.fromCharCode(0xD2) + String.fromCharCode(0xDB), // క్భ
        3118: String.fromCharCode(0x88), // క్మ
        3119: String.fromCharCode(0xAB), // క్య
        3120: String.fromCharCode(0xE7), // క్ర
        3121: String.fromCharCode(0x5F), // క్ఱ
        3122: String.fromCharCode(0xA2), // క్ల
        3123: String.fromCharCode(0xDF), // క్ళ
        3124: "", // క్
        3125: String.fromCharCode(0xC7), // క్వ
        3126: String.fromCharCode(0xF4), // క్శ
        3127: String.fromCharCode(0xFC), // క్ష
        3128: String.fromCharCode(0xE0), // క్స
        3129: String.fromCharCode(0xBD), // క్హ
    },

    consonants: {
        3093: { base: String.fromCharCode(0xC5) + String.fromCharCode(0xB7), symbols: { 3134: String.fromCharCode(0xC5) + String.fromCharCode(0x91), 3135: String.fromCharCode(0xC5) + String.fromCharCode(0x8D), 3136: String.fromCharCode(0xC5) + String.fromCharCode(0xA1), 3137: String.fromCharCode(0xC5) + String.fromCharCode(0xB7) + String.fromCharCode(0x94), 3138: String.fromCharCode(0xC5) + String.fromCharCode(0xB7) + String.fromCharCode(0x4C), 3142: String.fromCharCode(0xC2) + String.fromCharCode(0xBF), 3143: String.fromCharCode(0xB9) + String.fromCharCode(0xBF), 3144: String.fromCharCode(0xC2) + String.fromCharCode(0xBF) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0xBF) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0xBF) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0xBF) + String.fromCharCode(0x9A), 3149: String.fromCharCode(0xBF) + String.fromCharCode(0xF9) } },
        3094: { base: String.fromCharCode(0x4B), symbols: { 3134: String.fromCharCode(0x55) + String.fromCharCode(0xB2), 3135: String.fromCharCode(0xCF), 3136: String.fromCharCode(0x46), 3137: String.fromCharCode(0x4B) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x4B) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x55) + String.fromCharCode(0xC9) + String.fromCharCode(0xD5), 3143: String.fromCharCode(0x55) + String.fromCharCode(0xF1), 3144: String.fromCharCode(0x55) + String.fromCharCode(0xC9) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x55) + String.fromCharCode(0xA4), 3147: String.fromCharCode(0x55) + String.fromCharCode(0xCB), 3148: String.fromCharCode(0x55) + String.fromCharCode(0x85), 3149: String.fromCharCode(0x55) + String.fromCharCode(0xD9) } },
        3095: { base: String.fromCharCode(0x3E) + String.fromCharCode(0xB7), symbols: { 3134: String.fromCharCode(0x3E) + String.fromCharCode(0xB1), 3135: String.fromCharCode(0xD0), 3136: String.fromCharCode(0x5E), 3137: String.fromCharCode(0x3E) + String.fromCharCode(0xB7) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x3E) + String.fromCharCode(0xB7) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0xC2) + String.fromCharCode(0x3E), 3143: String.fromCharCode(0xB9) + String.fromCharCode(0x3E), 3144: String.fromCharCode(0xC2) + String.fromCharCode(0x3E) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x3E) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x3E) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x3E) + String.fromCharCode(0x9A), 3149: String.fromCharCode(0x3E) + String.fromCharCode(0xB4) } },
        3096: { base: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x9F) + String.fromCharCode(0x54), symbols: { 3134: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x9F) + String.fromCharCode(0xD6), 3135: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0xBE) + String.fromCharCode(0x54), 3136: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0xD3) + String.fromCharCode(0x54), 3137: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x9F) + String.fromCharCode(0x54) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x9F) + String.fromCharCode(0x54) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x99) + String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x54), 3143: String.fromCharCode(0x9D) + String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x54), 3144: String.fromCharCode(0x99) + String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x54) + String.fromCharCode(0xAE), 3146: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x9F) + String.fromCharCode(0x54) + String.fromCharCode(0xA4), 3147: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x9F) + String.fromCharCode(0x54) + String.fromCharCode(0xCB), 3148: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x9F) + String.fromCharCode(0x54) + String.fromCharCode(0xF2), 3149: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x74) + String.fromCharCode(0x54) } },
        3098: { base: String.fromCharCode(0x23) + String.fromCharCode(0xE1), symbols: { 3134: String.fromCharCode(0x23) + String.fromCharCode(0x90), 3135: String.fromCharCode(0xBA), 3136: String.fromCharCode(0x4E), 3137: String.fromCharCode(0x23) + String.fromCharCode(0xE1) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x23) + String.fromCharCode(0xE1) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x23) + String.fromCharCode(0xEE), 3143: String.fromCharCode(0x23) + String.fromCharCode(0xFB), 3144: String.fromCharCode(0x23) + String.fromCharCode(0xEE) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x23) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x23) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x23) + String.fromCharCode(0xEA), 3149: String.fromCharCode(0x23) + String.fromCharCode(0x59) } },
        3099: { base: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0xE1), symbols: { 3134: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0x90), 3135: String.fromCharCode(0xBA) + String.fromCharCode(0xF3), 3136: String.fromCharCode(0x4E) + String.fromCharCode(0xF3), 3137: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0xE1) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0xE1) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0xEE), 3143: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0xFB), 3144: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0xEE) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0xEA), 3149: String.fromCharCode(0x23) + String.fromCharCode(0xF3) + String.fromCharCode(0x59) } },
        3100: { base: String.fromCharCode(0xC8), symbols: { 3134: String.fromCharCode(0x43) + String.fromCharCode(0xB2), 3135: String.fromCharCode(0x9B), 3136: String.fromCharCode(0x4A), 3137: String.fromCharCode(0x45), 3138: String.fromCharCode(0x70), 3142: String.fromCharCode(0x43) + String.fromCharCode(0xC9), 3143: String.fromCharCode(0x43) + String.fromCharCode(0xF1), 3144: String.fromCharCode(0x43) + String.fromCharCode(0xC9) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x43) + String.fromCharCode(0xA4), 3147: String.fromCharCode(0x43) + String.fromCharCode(0xCB), 3148: String.fromCharCode(0x43) + String.fromCharCode(0x85), 3149: String.fromCharCode(0x43) + String.fromCharCode(0xD9) } },
        3101: { base: String.fromCharCode(0x73) + String.fromCharCode(0xC1) + String.fromCharCode(0x61), symbols: { 3134: String.fromCharCode(0x73) + String.fromCharCode(0xC1) + String.fromCharCode(0x61) + String.fromCharCode(0x6E), 3135: String.fromCharCode(0x5D) + String.fromCharCode(0x61), 3136: String.fromCharCode(0xAF) + String.fromCharCode(0x61), 3137: String.fromCharCode(0x73) + String.fromCharCode(0xC1) + String.fromCharCode(0x61) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x73) + String.fromCharCode(0xC1) + String.fromCharCode(0x61) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0xC2) + String.fromCharCode(0x73) + String.fromCharCode(0x61), 3143: String.fromCharCode(0xB9) + String.fromCharCode(0x73) + String.fromCharCode(0x61), 3144: String.fromCharCode(0xC2) + String.fromCharCode(0x73) + String.fromCharCode(0x61) + String.fromCharCode(0xAE), 3146: String.fromCharCode(0xC2) + String.fromCharCode(0x73) + String.fromCharCode(0x61) + String.fromCharCode(0x54), 3147: String.fromCharCode(0xC2) + String.fromCharCode(0x73) + String.fromCharCode(0x61) + String.fromCharCode(0xB2), 3148: String.fromCharCode(0x73) + String.fromCharCode(0xC1) + String.fromCharCode(0x61) + String.fromCharCode(0xF2), 3149: String.fromCharCode(0x73) + String.fromCharCode(0x59) + String.fromCharCode(0x61) } },
        3103: { base: String.fromCharCode(0x66), symbols: { 3134: String.fromCharCode(0x7B) + String.fromCharCode(0xB2), 3135: String.fromCharCode(0x7B) + String.fromCharCode(0xEC), 3136: String.fromCharCode(0x7B) + String.fromCharCode(0xA1), 3137: String.fromCharCode(0xB3) + String.fromCharCode(0x54), 3138: String.fromCharCode(0xB3) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x66) + String.fromCharCode(0xC9), 3143: String.fromCharCode(0x66) + String.fromCharCode(0xF1), 3144: String.fromCharCode(0x66) + String.fromCharCode(0xC9) + String.fromCharCode(0xAE), 3146: String.fromCharCode(0x7B) + String.fromCharCode(0xA4), 3147: String.fromCharCode(0x7B) + String.fromCharCode(0xCB), 3148: String.fromCharCode(0x7B) + String.fromCharCode(0x85), 3149: String.fromCharCode(0x7B) + String.fromCharCode(0xD9) } },
        3104: { base: String.fromCharCode(0x73) + String.fromCharCode(0xC4) + String.fromCharCode(0xC1), symbols: { 3134: String.fromCharCode(0x73) + String.fromCharCode(0xC4) + String.fromCharCode(0x90), 3135: String.fromCharCode(0x5D) + String.fromCharCode(0xC4), 3136: String.fromCharCode(0xAF) + String.fromCharCode(0xC4), 3137: String.fromCharCode(0x73) + String.fromCharCode(0xC4) + String.fromCharCode(0xC1) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x73) + String.fromCharCode(0xC4) + String.fromCharCode(0xC1) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0xC2) + String.fromCharCode(0x73) + String.fromCharCode(0xC4), 3143: String.fromCharCode(0xB9) + String.fromCharCode(0x73) + String.fromCharCode(0xC4), 3144: String.fromCharCode(0xC2) + String.fromCharCode(0x73) + String.fromCharCode(0xC4) + String.fromCharCode(0xd5), 3146: String.fromCharCode(0x73) + String.fromCharCode(0xC4) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x73) + String.fromCharCode(0xC4) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x73) + String.fromCharCode(0xC4) + String.fromCharCode(0x9A), 3149: String.fromCharCode(0x73) + String.fromCharCode(0xC4) + String.fromCharCode(0x59) } },
        3105: { base: String.fromCharCode(0x26) + String.fromCharCode(0xE1), symbols: { 3134: String.fromCharCode(0x26) + String.fromCharCode(0x86), 3135: String.fromCharCode(0x26) + String.fromCharCode(0x8D), 3136: String.fromCharCode(0x26) + String.fromCharCode(0x9E), 3137: String.fromCharCode(0x26) + String.fromCharCode(0x83) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x26) + String.fromCharCode(0x83) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x26) + String.fromCharCode(0xEE), 3143: String.fromCharCode(0x26) + String.fromCharCode(0xFB), 3144: String.fromCharCode(0x26) + String.fromCharCode(0xEE) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x26) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x26) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x26) + String.fromCharCode(0xEA), 3149: String.fromCharCode(0x26) + String.fromCharCode(0x8E) } },
        3106: { base: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0x83), symbols: { 3134: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0x86), 3135: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0x8D), 3136: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0x9E), 3137: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0x83) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0x83) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0xEE), 3143: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0xFB), 3144: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0xEE) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0xEA), 3149: String.fromCharCode(0x26) + String.fromCharCode(0xF3) + String.fromCharCode(0x8E) } },
        3107: { base: String.fromCharCode(0x44), symbols: { 3134: String.fromCharCode(0x44) + String.fromCharCode(0xB2), 3135: String.fromCharCode(0x44) + String.fromCharCode(0xEC), 3136: String.fromCharCode(0x44) + String.fromCharCode(0xA1), 3137: String.fromCharCode(0x44) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x44) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x44) + String.fromCharCode(0xC9), 3143: String.fromCharCode(0x44) + String.fromCharCode(0xF1), 3144: String.fromCharCode(0x44) + String.fromCharCode(0xC9) + String.fromCharCode(0xAE), 3146: String.fromCharCode(0x44) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x44) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x44) + String.fromCharCode(0x85), 3149: String.fromCharCode(0x44) + String.fromCharCode(0x59) } },
        3108: { base: String.fromCharCode(0xD4) + String.fromCharCode(0xE1), symbols: { 3134: String.fromCharCode(0xD4) + String.fromCharCode(0x90), 3135: String.fromCharCode(0xDC), 3136: String.fromCharCode(0x72), 3137: String.fromCharCode(0xD4) + String.fromCharCode(0xE1) + String.fromCharCode(0x54), 3138: String.fromCharCode(0xD4) + String.fromCharCode(0xE1) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0xD4) + String.fromCharCode(0xEE), 3143: String.fromCharCode(0xD4) + String.fromCharCode(0xFB), 3144: String.fromCharCode(0xD4) + String.fromCharCode(0xEE) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0xD4) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0xD4) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0xD4) + String.fromCharCode(0xEA), 3149: String.fromCharCode(0xD4) + String.fromCharCode(0x59) } },
        3109: { base: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0xE1), symbols: { 3134: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0x91), 3135: String.fromCharCode(0x7E) + String.fromCharCode(0xB8), 3136: String.fromCharCode(0x42) + String.fromCharCode(0xB8), 3137: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0x8A) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0x8A) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0xEE), 3143: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0xFB), 3144: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0xEE) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0xEA), 3149: String.fromCharCode(0x3C) + String.fromCharCode(0xB8) + String.fromCharCode(0x8E) } },
        3110: { base: String.fromCharCode(0x3C) + String.fromCharCode(0x8A), symbols: { 3134: String.fromCharCode(0x3C) + String.fromCharCode(0x91), 3135: String.fromCharCode(0x7E), 3136: String.fromCharCode(0x42), 3137: String.fromCharCode(0x3C) + String.fromCharCode(0x8A) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x3C) + String.fromCharCode(0x8A) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x3C) + String.fromCharCode(0xEE), 3143: String.fromCharCode(0x3C) + String.fromCharCode(0xFB), 3144: String.fromCharCode(0x3C) + String.fromCharCode(0xEE) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x3C) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x3C) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x3C) + String.fromCharCode(0xEA), 3149: String.fromCharCode(0x3C) + String.fromCharCode(0x8E) } },
        3111: { base: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0x8A), symbols: { 3134: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0x91), 3135: String.fromCharCode(0x7E) + String.fromCharCode(0xF3), 3136: String.fromCharCode(0x42) + String.fromCharCode(0xF3), 3137: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0x8A) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0x8A) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0xEE), 3143: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0xFB), 3144: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0xEE) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0xEA), 3149: String.fromCharCode(0x3C) + String.fromCharCode(0xF3) + String.fromCharCode(0x8E) } },
        3112: { base: String.fromCharCode(0x71), symbols: { 3134: String.fromCharCode(0x48) + String.fromCharCode(0x90), 3135: String.fromCharCode(0x93), 3136: String.fromCharCode(0xFA), 3137: String.fromCharCode(0x71) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x71) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x48) + String.fromCharCode(0xEE), 3143: String.fromCharCode(0x48) + String.fromCharCode(0xFB), 3144: String.fromCharCode(0x48) + String.fromCharCode(0xEE) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x48) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x48) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x48) + String.fromCharCode(0xEA), 3149: String.fromCharCode(0x48) + String.fromCharCode(0x8E) } },
        3114: { base: String.fromCharCode(0x7C) + String.fromCharCode(0x9F), symbols: { 3134: String.fromCharCode(0x62) + String.fromCharCode(0xCD), 3135: String.fromCharCode(0x7C) + String.fromCharCode(0xBE), 3136: String.fromCharCode(0x7C) + String.fromCharCode(0xD3), 3137: String.fromCharCode(0x7C) + String.fromCharCode(0x9F) + String.fromCharCode(0xDA), 3138: String.fromCharCode(0x7C) + String.fromCharCode(0x9F) + String.fromCharCode(0x50), 3142: String.fromCharCode(0x99) + String.fromCharCode(0x7C), 3143: String.fromCharCode(0x9D) + String.fromCharCode(0x7C), 3144: String.fromCharCode(0x99) + String.fromCharCode(0x7C) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x62) + String.fromCharCode(0xF5), 3147: String.fromCharCode(0x62) + String.fromCharCode(0xFE), 3148: String.fromCharCode(0x62) + String.fromCharCode(0xE5), 3149: String.fromCharCode(0x7C) + String.fromCharCode(0x74) } },
        3115: { base: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x9F), symbols: { 3134: String.fromCharCode(0x62) + String.fromCharCode(0x98) + String.fromCharCode(0xCD), 3135: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0xBE), 3136: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0xD3), 3137: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x9F) + String.fromCharCode(0xDA), 3138: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x9F) + String.fromCharCode(0x50), 3142: String.fromCharCode(0x99) + String.fromCharCode(0x7C) + String.fromCharCode(0x98), 3143: String.fromCharCode(0x9D) + String.fromCharCode(0x7C) + String.fromCharCode(0x98), 3144: String.fromCharCode(0x99) + String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x62) + String.fromCharCode(0x98) + String.fromCharCode(0xF5), 3147: String.fromCharCode(0x62) + String.fromCharCode(0x98) + String.fromCharCode(0xFE), 3148: String.fromCharCode(0x62) + String.fromCharCode(0x98) + String.fromCharCode(0xE5), 3149: String.fromCharCode(0x7C) + String.fromCharCode(0x98) + String.fromCharCode(0x74) } },
        3116: { base: String.fromCharCode(0x8B), symbols: { 3134: String.fromCharCode(0x75) + String.fromCharCode(0xB2), 3135: String.fromCharCode(0x5F), 3136: String.fromCharCode(0x3B), 3137: String.fromCharCode(0x8B) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x8B) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x75) + String.fromCharCode(0xC9), 3143: String.fromCharCode(0x75) + String.fromCharCode(0xF1), 3144: String.fromCharCode(0x75) + String.fromCharCode(0xC9) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x75) + String.fromCharCode(0xA4), 3147: String.fromCharCode(0x75) + String.fromCharCode(0xCB), 3148: String.fromCharCode(0x75) + String.fromCharCode(0x85), 3149: String.fromCharCode(0x8B) + String.fromCharCode(0xCA) } },
        3117: { base: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0x84), symbols: { 3134: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0xB2), 3135: String.fromCharCode(0x5F) + String.fromCharCode(0xF3), 3136: String.fromCharCode(0x3B) + String.fromCharCode(0xF3), 3137: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0x84) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0x84) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0xC9), 3143: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0xF1), 3144: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0xC9) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0xA4), 3147: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0xCB), 3148: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0x85), 3149: String.fromCharCode(0x75) + String.fromCharCode(0xF3) + String.fromCharCode(0x84) + String.fromCharCode(0xCA) } },
        3118: { base: String.fromCharCode(0x65) + String.fromCharCode(0x54), symbols: { 3134: String.fromCharCode(0x65) + String.fromCharCode(0xD6), 3135: String.fromCharCode(0x24) + String.fromCharCode(0x54), 3136: String.fromCharCode(0x4D) + String.fromCharCode(0x54), 3137: String.fromCharCode(0x65) + String.fromCharCode(0x54) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x65) + String.fromCharCode(0x54) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x79) + String.fromCharCode(0xEE) + String.fromCharCode(0x54), 3143: String.fromCharCode(0x79) + String.fromCharCode(0xFB) + String.fromCharCode(0x54), 3144: String.fromCharCode(0x79) + String.fromCharCode(0xEE) + String.fromCharCode(0x54) + String.fromCharCode(0xAE), 3146: String.fromCharCode(0x79) + String.fromCharCode(0xEE) + String.fromCharCode(0x54) + String.fromCharCode(0x54), 3147: String.fromCharCode(0x79) + String.fromCharCode(0xEE) + String.fromCharCode(0xD6), 3148: String.fromCharCode(0x65) + String.fromCharCode(0x54) + String.fromCharCode(0xF2), 3149: String.fromCharCode(0x79) + String.fromCharCode(0x8E) + String.fromCharCode(0x54) } },
        3119: { base: String.fromCharCode(0x6A) + String.fromCharCode(0xE1) + String.fromCharCode(0xA7), symbols: { 3134: String.fromCharCode(0x6A) + String.fromCharCode(0xE1) + String.fromCharCode(0xD6), 3135: String.fromCharCode(0x73) + String.fromCharCode(0x54) + String.fromCharCode(0x54), 3136: String.fromCharCode(0x73) + String.fromCharCode(0x54) + String.fromCharCode(0xD6), 3137: String.fromCharCode(0x6A) + String.fromCharCode(0xE1) + String.fromCharCode(0x54) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x6A) + String.fromCharCode(0xE1) + String.fromCharCode(0x54) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x6A) + String.fromCharCode(0xEE) + String.fromCharCode(0x54), 3143: String.fromCharCode(0x6A) + String.fromCharCode(0xFB) + String.fromCharCode(0x54), 3144: String.fromCharCode(0x6A) + String.fromCharCode(0xEE) + String.fromCharCode(0xAE) + String.fromCharCode(0x54), 3146: String.fromCharCode(0x6A) + String.fromCharCode(0xEE) + String.fromCharCode(0x54) + String.fromCharCode(0x54), 3147: String.fromCharCode(0x6A) + String.fromCharCode(0xEE) + String.fromCharCode(0xD6), 3148: String.fromCharCode(0x6A) + String.fromCharCode(0xE1) + String.fromCharCode(0x54) + String.fromCharCode(0xF2), 3149: String.fromCharCode(0x6A) + String.fromCharCode(0x59) + String.fromCharCode(0x54) } },
        3120: { base: String.fromCharCode(0x73) + String.fromCharCode(0xE1), symbols: { 3134: String.fromCharCode(0x73) + String.fromCharCode(0x90), 3135: String.fromCharCode(0x5D), 3136: String.fromCharCode(0xAF), 3137: String.fromCharCode(0x73) + String.fromCharCode(0xC1) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x73) + String.fromCharCode(0xC1) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0xC2) + String.fromCharCode(0x73), 3143: String.fromCharCode(0xB9) + String.fromCharCode(0x73), 3144: String.fromCharCode(0xC2) + String.fromCharCode(0x73) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x73) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x73) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x73) + String.fromCharCode(0x9A), 3149: String.fromCharCode(0x73) + String.fromCharCode(0x59) } },
        3122: { base: String.fromCharCode(0x5C), symbols: { 3134: String.fromCharCode(0xFD) + String.fromCharCode(0xB2), 3135: String.fromCharCode(0x2A), 3136: String.fromCharCode(0xA9), 3137: String.fromCharCode(0x5C) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x5C) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0xFD) + String.fromCharCode(0xC9), 3143: String.fromCharCode(0xFD) + String.fromCharCode(0xF1), 3144: String.fromCharCode(0xFD) + String.fromCharCode(0xC9) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0xFD) + String.fromCharCode(0xA4), 3147: String.fromCharCode(0xFD) + String.fromCharCode(0xCB), 3148: String.fromCharCode(0xFD) + String.fromCharCode(0x85), 3149: String.fromCharCode(0xFD) + String.fromCharCode(0xD9) } },
        3123: { base: String.fromCharCode(0xDE) + String.fromCharCode(0xF8), symbols: { 3134: String.fromCharCode(0xDE) + String.fromCharCode(0xB2), 3135: String.fromCharCode(0x5B), 3136: String.fromCharCode(0xB0), 3137: String.fromCharCode(0xDE) + String.fromCharCode(0xF8) + String.fromCharCode(0x97), 3138: String.fromCharCode(0xDE) + String.fromCharCode(0xF8) + String.fromCharCode(0x53), 3142: String.fromCharCode(0xDE) + String.fromCharCode(0xE8), 3143: String.fromCharCode(0xDE) + String.fromCharCode(0xE2), 3144: String.fromCharCode(0xDE) + String.fromCharCode(0xE8) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0xDE) + String.fromCharCode(0xA4), 3147: String.fromCharCode(0xDE) + String.fromCharCode(0xCB), 3148: String.fromCharCode(0xDE) + String.fromCharCode(0x85), 3149: String.fromCharCode(0xDE) + String.fromCharCode(0xD9) } },
        3125: { base: String.fromCharCode(0x65), symbols: { 3134: String.fromCharCode(0x79) + String.fromCharCode(0x90), 3135: String.fromCharCode(0x24), 3136: String.fromCharCode(0x4D), 3137: String.fromCharCode(0x65) + String.fromCharCode(0xDA), 3138: String.fromCharCode(0x65) + String.fromCharCode(0xDA), 3142: String.fromCharCode(0x79) + String.fromCharCode(0xEE), 3143: String.fromCharCode(0x79) + String.fromCharCode(0xFB), 3144: String.fromCharCode(0x79) + String.fromCharCode(0xEE) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x79) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x79) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x79) + String.fromCharCode(0xEA), 3149: String.fromCharCode(0x79) + String.fromCharCode(0x8E) } },
        3126: { base: String.fromCharCode(0x58) + String.fromCharCode(0xF8), symbols: { 3134: String.fromCharCode(0x58) + String.fromCharCode(0xE6), 3135: String.fromCharCode(0xA5), 3136: String.fromCharCode(0x6F), 3137: String.fromCharCode(0x58) + String.fromCharCode(0xF8) + String.fromCharCode(0x97), 3138: String.fromCharCode(0x58) + String.fromCharCode(0xF8) + String.fromCharCode(0x53), 3142: String.fromCharCode(0x58) + String.fromCharCode(0xE8), 3143: String.fromCharCode(0x58) + String.fromCharCode(0xE2), 3144: String.fromCharCode(0x58) + String.fromCharCode(0xE8) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x58) + String.fromCharCode(0xA4), 3147: String.fromCharCode(0x58) + String.fromCharCode(0xCB), 3148: String.fromCharCode(0x58) + String.fromCharCode(0x85), 3149: String.fromCharCode(0x58) + String.fromCharCode(0xD9) } },
        3127: { base: String.fromCharCode(0x77) + String.fromCharCode(0x9F), symbols: { 3134: String.fromCharCode(0x63) + String.fromCharCode(0xCD), 3135: String.fromCharCode(0x77) + String.fromCharCode(0xBE), 3136: String.fromCharCode(0x77) + String.fromCharCode(0xD3), 3137: String.fromCharCode(0x77) + String.fromCharCode(0x9F) + String.fromCharCode(0xA7), 3138: String.fromCharCode(0x77) + String.fromCharCode(0x9F) + String.fromCharCode(0x4F), 3142: String.fromCharCode(0x99) + String.fromCharCode(0x77), 3143: String.fromCharCode(0x9D) + String.fromCharCode(0x77), 3144: String.fromCharCode(0x99) + String.fromCharCode(0x77) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x63) + String.fromCharCode(0xF5), 3147: String.fromCharCode(0x63) + String.fromCharCode(0xFE), 3148: String.fromCharCode(0x63) + String.fromCharCode(0xE5), 3149: String.fromCharCode(0x77) + String.fromCharCode(0x74) } },
        3128: { base: String.fromCharCode(0x64) + String.fromCharCode(0x9F), symbols: { 3134: String.fromCharCode(0x6B) + String.fromCharCode(0xCD), 3135: String.fromCharCode(0x64) + String.fromCharCode(0xBE), 3136: String.fromCharCode(0x64) + String.fromCharCode(0xD3), 3137: String.fromCharCode(0x64) + String.fromCharCode(0x9F) + String.fromCharCode(0x54), 3138: String.fromCharCode(0x64) + String.fromCharCode(0x9F) + String.fromCharCode(0xD6), 3142: String.fromCharCode(0x99) + String.fromCharCode(0x64), 3143: String.fromCharCode(0x9D) + String.fromCharCode(0x64), 3144: String.fromCharCode(0x99) + String.fromCharCode(0x64) + String.fromCharCode(0xD5), 3146: String.fromCharCode(0x6B) + String.fromCharCode(0xF5), 3147: String.fromCharCode(0x6B) + String.fromCharCode(0xFE), 3148: String.fromCharCode(0x6B) + String.fromCharCode(0xE5), 3149: String.fromCharCode(0x64) + String.fromCharCode(0x74) } },
        3129: { base: String.fromCharCode(0x56) + String.fromCharCode(0x9F) + String.fromCharCode(0xB2), symbols: { 3134: String.fromCharCode(0x56) + String.fromCharCode(0x9F) + String.fromCharCode(0xE4), 3135: String.fromCharCode(0x56) + String.fromCharCode(0xBE) + String.fromCharCode(0xB2), 3136: String.fromCharCode(0x56) + String.fromCharCode(0xD3) + String.fromCharCode(0xB2), 3137: String.fromCharCode(0x56) + String.fromCharCode(0x9F) + String.fromCharCode(0x51), 3138: String.fromCharCode(0x56) + String.fromCharCode(0x9F) + String.fromCharCode(0x41), 3142: String.fromCharCode(0x99) + String.fromCharCode(0x56) + String.fromCharCode(0xB2), 3143: String.fromCharCode(0x9D) + String.fromCharCode(0x56) + String.fromCharCode(0xB2), 3144: String.fromCharCode(0x99) + String.fromCharCode(0x56) + String.fromCharCode(0xD5) + String.fromCharCode(0xB2), 3146: String.fromCharCode(0x56) + String.fromCharCode(0x9F) + String.fromCharCode(0xB2) + String.fromCharCode(0x3D), 3147: String.fromCharCode(0x56) + String.fromCharCode(0x9F) + String.fromCharCode(0xB2) + String.fromCharCode(0xC3), 3148: String.fromCharCode(0x56) + String.fromCharCode(0x9F) + String.fromCharCode(0xB2) + String.fromCharCode(0x85), 3149: String.fromCharCode(0x56) + String.fromCharCode(0x74) + String.fromCharCode(0xB2) } }
    }
};
