<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unicode → Anu Converter</title>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
</head>
<body>

    <!-- Main Container -->
    <div class="main-wrapper">
        
        <!-- Header -->
        <header class="page-header">
            <h1>Unicode → Anu Converter</h1>
            <p>Convert Telugu Unicode text to Anu6/7 font encoding for print.</p>
        </header>

        <!-- Converter Area -->
        <div class="converter-grid">
            
            <!-- Left Card: Input -->
            <div class="card">
                <div class="card-header">
                    <label for="unicodeInput">Unicode Input (Telugu)</label>
                </div>
                <div class="card-body">
                    <textarea id="unicodeInput" placeholder="Enter Telugu text here..."></textarea>
                </div>
                <div class="card-footer">
                    <button id="convertBtn" class="btn btn-primary">Convert</button>
                    <div class="mapping-select">
                        <span>Mapping:</span>
                        <select id="mappingSelect">
                            <option value="anu7">Anu7</option>
                            <option value="anu6">Anu6</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Right Card: Output -->
            <div class="card">
                <div class="card-header">
                    <label id="outputLabel" for="anuOutput">Anu7 output</label>
                </div>
                <div class="card-body">
                    <textarea id="anuOutput" readonly placeholder="Output will appear here..."></textarea>
                </div>
                <div class="card-footer">
                    <button id="copyBtn" class="btn btn-secondary">Copy to Clipboard</button>
                    <span id="copyMsg" class="success-msg" style="display:none;">Copied!</span>
                </div>

            </div>

        </div>

    </div>

    <!-- Core Logic -->
    <!-- Core Logic -->
    <script src="<?php echo e(asset('js/mappings/anu7.js')); ?>"></script>
    <script src="<?php echo e(asset('js/mappings/anu6.js')); ?>"></script>
    <script src="<?php echo e(asset('js/converter.js')); ?>"></script>
</body>
</html>
<?php /**PATH C:\Users\hp\Desktop\converter\converter-app\resources\views/converter.blade.php ENDPATH**/ ?>